/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.property.tables;

import filenet.vw.api.VWFieldType;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.property.dialog.VWWorkClassProxy;
import filenet.vw.toolkit.design.property.resources.VWResource;
import filenet.vw.toolkit.design.property.tables.IVWExpressionCellEditorTableModel;
import filenet.vw.toolkit.utils.IVWPropertyData;
import filenet.vw.toolkit.utils.uicontrols.expressionbuilder.VWExpressionBuilderDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import java.util.Locale;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.EventListenerList;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;

public class VWExpressionCellEditor
implements TableCellEditor,
ActionListener,
KeyListener {
    public static final int NORMAL = 0;
    public static final int WFC_LVALUE = 100;
    public static final int WFC_RVALUE = 101;
    public static final int CWF_LVALUE = 102;
    public static final int CWF_RVALUE = 103;
    protected static final int VALUE_NA = 0;
    protected static final int VALUE_NO_CHANGE = 1;
    protected static final int VALUE_UPDATED = 2;
    protected static final int VALUE_INVALID = 3;
    protected JTable m_table = null;
    protected JPanel m_panel = null;
    protected JTextField m_textField = null;
    protected JButton m_button = null;
    protected VWExpressionBuilderDialog m_expressionDialog = null;
    protected boolean m_editingWithDialog = false;
    protected boolean m_bEditing = false;
    protected boolean m_bButtonClickedBeforeReady = false;
    protected IVWPropertyData m_propertyData = null;
    protected int m_orientation = 0;
    protected int m_row = -1;
    protected int m_column = -1;
    protected VWWorkClassProxy m_workClassProxy = null;
    protected String m_lValue = null;
    protected int m_lValueDataType = 0;
    protected boolean m_bLValueIsArray = false;
    private boolean m_bFunctionsFlagOnly = false;
    protected EventListenerList listenerList = new EventListenerList();
    protected transient ChangeEvent changeEvent = null;
    protected int clickCountToStart = 1;
    protected String m_currentValue = null;
    protected boolean m_bUpdatingValue = false;
    private int m_defaultItem = 1;
    private String m_defaultSubItem = null;

    public VWExpressionCellEditor(IVWPropertyData propertyData) {
        this.m_propertyData = propertyData;
        this.m_panel = new JPanel();
        this.m_button = new JButton("..."){

            public void requestFocus() {
                if (!VWExpressionCellEditor.this.m_bEditing) {
                    VWExpressionCellEditor.this.m_bButtonClickedBeforeReady = true;
                } else {
                    super.requestFocus();
                }
            }
        };
        this.m_button.setMargin(new Insets(0, 0, 0, 0));
        this.m_button.setToolTipText(VWResource.s_expressionBuilderStr);
        this.m_textField = new JTextField();
        this.m_panel.setLayout(new BorderLayout());
        this.m_panel.add((Component)this.m_textField, "Center");
        this.m_panel.add((Component)this.m_button, "After");
        ComponentOrientation o = ComponentOrientation.getOrientation(Locale.getDefault());
        this.m_panel.setComponentOrientation(o);
        this.m_textField.setComponentOrientation(o);
    }

    public VWExpressionCellEditor(IVWPropertyData propertyData, int orientation) {
        this(propertyData);
        this.m_orientation = orientation;
    }

    public VWExpressionCellEditor(IVWPropertyData propertyData, boolean bFunctionsFlagOnly) {
        this(propertyData);
        this.m_bFunctionsFlagOnly = bFunctionsFlagOnly;
    }

    public void setDefaultItem(int defaultItem, String defaultSubItem) {
        this.m_defaultItem = defaultItem;
        this.m_defaultSubItem = defaultSubItem;
    }

    public void setWorkClassProxy(VWWorkClassProxy workClassProxy) {
        this.m_workClassProxy = workClassProxy;
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        IVWExpressionCellEditorTableModel expressionTableModel;
        String[] assignmentValues;
        this.m_row = row;
        this.m_column = column;
        this.m_table = table;
        this.m_currentValue = (String)value;
        if (this.m_currentValue != null) {
            this.m_textField.setText(this.m_currentValue);
            this.m_textField.setEditable(true);
        }
        this.addListeners();
        this.m_textField.requestFocus();
        TableModel tableModel = table.getModel();
        if (tableModel instanceof IVWExpressionCellEditorTableModel && (assignmentValues = (expressionTableModel = (IVWExpressionCellEditorTableModel)((Object)tableModel)).getItemAt(row)) != null) {
            this.m_lValue = assignmentValues[0];
            try {
                this.m_lValueDataType = VWFieldType.lValue(this.m_lValue, null, this.m_propertyData.getWorkflowDefinition());
            }
            catch (Exception ex) {
                this.m_lValueDataType = 0;
            }
            this.m_bLValueIsArray = this.m_lValueDataType < 0;
            this.m_lValueDataType = Math.abs(this.m_lValueDataType);
            this.m_textField.setEditable(true);
        }
        return this.m_panel;
    }

    public void addCellEditorListener(CellEditorListener l) {
        this.listenerList.add(CellEditorListener.class, l);
    }

    public void cancelCellEditing() {
        this.removeListeners();
        this.fireEditingCanceled();
        this.m_bEditing = false;
    }

    public int getClickCountToStart() {
        return this.clickCountToStart;
    }

    public Object getCellEditorValue() {
        return this.m_currentValue;
    }

    public boolean isCellEditable(EventObject anEvent) {
        boolean result = true;
        if (anEvent != null && anEvent instanceof MouseEvent && ((MouseEvent)anEvent).getClickCount() < this.clickCountToStart) {
            result = false;
        }
        return result;
    }

    public void removeCellEditorListener(CellEditorListener l) {
        this.listenerList.remove(CellEditorListener.class, l);
    }

    public boolean shouldSelectCell(EventObject anEvent) {
        boolean retValue = true;
        if (this.isCellEditable(anEvent) && anEvent instanceof MouseEvent && (anEvent == null || ((MouseEvent)anEvent).getClickCount() >= this.clickCountToStart)) {
            retValue = this.startCellEditing(anEvent);
        }
        return retValue;
    }

    public void setClickCountToStart(int count) {
        this.clickCountToStart = count;
    }

    public boolean startCellEditing(EventObject evt) {
        this.m_bEditing = true;
        this.m_panel.updateUI();
        return true;
    }

    public boolean stopCellEditing() {
        this.updateCurrentValue();
        this.removeListeners();
        this.fireEditingStopped();
        this.m_bEditing = false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void actionPerformed(ActionEvent event) {
        if (this.m_bButtonClickedBeforeReady) {
            this.m_bButtonClickedBeforeReady = false;
            return;
        }
        if (this.m_editingWithDialog) {
            return;
        }
        this.updateCurrentValue();
        this.m_editingWithDialog = true;
        try {
            block15: {
                try {
                    Container parent;
                    this.m_textField.setText(VWResource.s_editing);
                    this.m_textField.setEditable(false);
                    int nFlags = -1;
                    if (this.m_bFunctionsFlagOnly) {
                        nFlags = 8;
                    } else {
                        nFlags = 3727;
                        if (this.m_orientation == 101 || this.m_orientation == 100) {
                            nFlags |= 0x20;
                        } else if (this.m_orientation == 102 || this.m_orientation == 103) {
                            nFlags |= 0x40;
                        }
                    }
                    int orientation = -1;
                    if (this.m_orientation != 0) {
                        int n = orientation = this.m_orientation == 101 || this.m_orientation == 103 ? 2 : 1;
                    }
                    if ((parent = this.getParentContainer()) instanceof Frame) {
                        this.m_expressionDialog = new VWExpressionBuilderDialog((Frame)parent, this.m_propertyData, null, this.m_currentValue, nFlags, orientation);
                    } else if (parent instanceof Dialog) {
                        this.m_expressionDialog = new VWExpressionBuilderDialog((Dialog)parent, this.m_propertyData, null, this.m_currentValue, nFlags, orientation);
                    }
                    if (this.m_expressionDialog == null) break block15;
                    this.m_expressionDialog.setWorkClassProxy(this.m_workClassProxy);
                    this.m_expressionDialog.setDefaultItems(this.m_defaultItem, this.m_defaultSubItem);
                    this.m_expressionDialog.setValueInfo(this.m_lValue, this.m_lValueDataType, this.m_bLValueIsArray);
                    this.m_expressionDialog.init();
                    this.m_expressionDialog.setVisible(true);
                    this.updateCurrentValue();
                }
                catch (Exception ex) {
                    VWDebug.logException(ex);
                    Object var6_7 = null;
                    this.m_textField.setText(this.m_currentValue);
                    this.m_textField.setEditable(true);
                    this.m_textField.requestFocus();
                    this.m_editingWithDialog = false;
                    return;
                }
            }
            Object var6_6 = null;
            this.m_textField.setText(this.m_currentValue);
            this.m_textField.setEditable(true);
            this.m_textField.requestFocus();
            this.m_editingWithDialog = false;
            return;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            this.m_textField.setText(this.m_currentValue);
            this.m_textField.setEditable(true);
            this.m_textField.requestFocus();
            this.m_editingWithDialog = false;
            throw throwable;
        }
    }

    public void keyPressed(KeyEvent event) {
    }

    public void keyReleased(KeyEvent event) {
    }

    public void keyTyped(KeyEvent event) {
        if (event.getSource() == this.m_table) {
            this.startCellEditing(event);
            this.m_textField.requestFocus();
            return;
        }
        if (event.getKeyChar() == '\n') {
            switch (this.updateCurrentValue()) {
                case 2: {
                    this.stopCellEditing();
                    break;
                }
                case 0: {
                    this.cancelCellEditing();
                }
            }
        }
    }

    protected Container getParentContainer() {
        Container component = this.m_table;
        while (component != null) {
            Container parent = component.getParent();
            if (parent instanceof Frame || parent instanceof Dialog) {
                return parent;
            }
            component = parent;
        }
        if (this.m_propertyData != null) {
            return this.m_propertyData.getMainContainer();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int updateCurrentValue() {
        int nResult = 1;
        try {
            block9: {
                try {
                    if (this.m_bUpdatingValue) {
                        nResult = 0;
                        break block9;
                    }
                    if (this.m_editingWithDialog) {
                        if (this.m_expressionDialog != null) {
                            this.m_bUpdatingValue = true;
                            if (this.m_expressionDialog.getDialogResult() == 1) {
                                nResult = 1;
                            } else {
                                this.m_currentValue = this.m_expressionDialog.getExpressionString();
                                nResult = 2;
                            }
                        }
                        break block9;
                    }
                    this.m_currentValue = this.m_textField.getText();
                    nResult = 2;
                }
                catch (Exception ex) {
                    VWDebug.logException(ex);
                    Object var4_3 = null;
                    this.m_bUpdatingValue = false;
                }
            }
            Object var4_2 = null;
            this.m_bUpdatingValue = false;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.m_bUpdatingValue = false;
            throw throwable;
        }
        return nResult;
    }

    protected void fireEditingStopped() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != CellEditorListener.class) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((CellEditorListener)listeners[i + 1]).editingStopped(this.changeEvent);
        }
    }

    protected void fireEditingCanceled() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != CellEditorListener.class) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((CellEditorListener)listeners[i + 1]).editingCanceled(this.changeEvent);
        }
    }

    private void addListeners() {
        if (this.m_table != null) {
            this.m_table.addKeyListener(this);
        }
        if (this.m_textField != null) {
            this.m_textField.addKeyListener(this);
        }
        if (this.m_button != null) {
            this.m_button.addActionListener(this);
        }
    }

    private void removeListeners() {
        if (this.m_table != null) {
            this.m_table.removeKeyListener(this);
            this.m_table = null;
        }
        if (this.m_textField != null) {
            this.m_textField.removeKeyListener(this);
        }
        if (this.m_button != null) {
            this.m_button.removeActionListener(this);
        }
    }
}

